#--------------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.11.3
#---------------------------------------------------------------------------------------#
start.time <- proc.time()[3]
library("tolerance")


expn <- seq(1, 10, 1)
lr <- c(rep (2.5, 3), rep(7.5, 4), rep(12.5, 3))
ph <- c(4.7, 5, 5.3, 4.7, 5, 5, 5.3, 4.7, 5, 5.3)
y <- c(94.01, 94.91, 99.65, 75.7, 81.54, 84.92, 91.37, 67.11, 80.62, 92.36)
table227DS <- data.frame(Experiment = expn, Loadrate=lr, pH = ph, Y =y)
table227DS

table227.fit <- lm(Y ~ Loadrate + pH, data = table227DS)
summary(table227.fit)

newds <- data.frame(Loadrate = 7.5, pH = 5)

confint(table227.fit, c("Loadrate", "pH"), level=0.95)
predict(table227.fit, newds, interval="confidence")
predict(table227.fit, newds, interval="prediction")
out <- regtol.int(table227.fit, new.x = newds, alpha=0.05, P=0.99, side=2)
out

cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600, "\n")
rm(list=ls(all=TRUE))
#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#